ORCA/M Asm65816 2.1.0

0001 1805                       title 'COMMON       GS ROM 3.0'
0002 1805              ****************************************************************
0003 1805              *                                                              *
0004 1805              *              Common                                          *
0005 1805              *                                                              *
0006 1805              ****************************************************************
0007 1805
0008 1805
0009 1805              ****************************************************************
0010 1805              *                                                              *
0011 1805              *                   Copyright (C) 1985-1988                    *
0012 1805              *                   All Rights Reserved                        *
0013 1805              *                   Apple Computer, Inc.                       *
0014 1805              *                                                              *
0015 1805              ****************************************************************
0016 1805
0017 1805              **********************************************************************
0018 1805              *
0019 1805              * Change History
0020 1805              *
0021 1805              * 10 Jun 88         Steven Glass
0022 1805              *
0023 1805              * This file contains the strip code again.
0024 1805              *
0025 1805              * The 0-strip routines do not fall through the common code but rather
0026 1805              * short cut the process saving cycles.  This should get the 
0027 1805              * UCSD Pascal working again.
0028 1805              *
0029 1805              **********************************************************************
0030 1805
0031 1805                       include '::sys.equs.asm' 
0032 1805
0033 1805              ;-----------------------------------------------
0034 1805              ;
0035 1805              ;   Forward addresses and entries
0036 1805              ;
0037 1805              ;-----------------------------------------------
0038 1805
0039 1805                       ENTRY ErrOut 
0040 1805                       ENTRY oBusyErr 
0041 1805                       ENTRY oErrOut 
0042 1805                       ENTRY oErrOut0 
0043 1805
0044 1805              ****************************************************************
0045 1805              *
0046 1805              * NotImp
0047 1805              *
0048 1805              ****************************************************************
0049 1805                       EXPORT NotImp
0050 1805              NotImp   PROC 
0051 1805
0052 1805 A2 FF FF              ldx   #$FFFF
0053 1808 4C 10 1D              jmp   oErrOut0
0054 180B
0055 180B                       ENDP 
0056 180B
0057 180B
0058 180B              ****************************************************************
0059 180B              *
0060 180B              * EndCall Routines.
0061 180B              *
0062 180B              * Functions exit through the EndCall routines.  These routines
0063 180B              * fix the stack by moving the RTL addresses up and stripping
0064 180B              * off any input parameters.
0065 180B              *
0066 180B              * The number of bytes to strip off the stack is passed in the
0067 180B              * y-register.
0068 180B              *
0069 180B              * There are 8 end call routines
0070 180B              *
0071 180B              *       EndCall        Pulls D off stack before cleaning up.  Sets
0072 180B              *                      a-reg to zero and clears carry.
0073 180B              *       oEndCall       Does not pull D off the stack before
0074 180B              *                      cleaning up.  Sets a-reg to zero and clears
0075 180B              *                      carry.
0076 180B              *       ErrOut         Pulls D off stack, cleans up and returns
0077 180B              *                      error code passed in x-register, setting
0078 180B              *                      carry if x is not zero.
0079 180B              *       oErrOut        Does not pull D off stack before cleaning up.
0080 180B              *                      returns error code passed in x-register,
0081 180B              *                      setting carry if x is not zero.
0082 180B              *
0083 180B              *       BusyEC         Decrements the busy flag, pulls D off stack
0084 180B              *                      and cleans up.
0085 180B              *       oBusyEC        Decrements the busy flag, does not pull D off stack
0086 180B              *                      and cleans up.
0087 180B              *       BusyErr        Decrements the busy flag, pulls D off stack,
0088 180B              *                      cleans up and returns error code passed in
0089 180B              *                      x-register, setting the carry if x is not zero.
0090 180B              *       oBusyErr       Decrements the busy flag, does not pull D off
0091 180B              *                      the stack, cleans up and returns error code passed
0092 180B              *                      in x-register.
0093 180B              *
0094 180B              ****************************************************************
0095 180B
0096 180B
0097 180B
0098 180B                       EXPORT oEndCall0
0099 180B              oEndCall0 PROC 
0100 180B 0B                    phd   
0101 180C                       EXPORT EndCall0
0102 180C              EndCall0                                ; 
0103 180C A2 00 00              ldx   #0
0104 180F                       EXPORT ErrOut0
0105 180F              ErrOut0                                 ; 
0106 180F 2B                    pld   
0107 1810                       EXPORT oErrOut0
0108 1810              oErrOut0                                ; 
0109 1810 8A                    txa   
0110 1811 C9 01 00              cmp   #1
0111 1814 6B                    rtl   
0112 1815                       ENDP 
0113 1815
0114 1815                       EXPORT oBusyEC0
0115 1815              oBusyEC0 PROC 
0116 1815 0B                    phd   
0117 1816                       EXPORT BusyEC0
0118 1816              BusyEC0                                 ; 
0119 1816 A2 00 00              ldx   #0
0120 1819                       EXPORT BusyErr0
0121 1819              BusyErr0                                ; 
0122 1819 2B                    pld   
0123 181A                       EXPORT oBusyErr0
0124 181A              oBusyErr0                               ; 
0125 181A 8A                    txa   
0126 181B C9 01 00              cmp   #1
0127 181E 22 68 00 E1           jsl   DecBusyFlg
0128 1822 6B                    rtl   
0129 1823                       ENDP 
0130 1823
0131 1823
0132 1823                       EXPORT oEndCall2
0133 1823              oEndCall2 PROC 
0134 1823 0B                    phd   
0135 1824                       EXPORT EndCall2
0136 1824              EndCall2                                ; 
0137 1824 A2 00 00              ldx   #0
0138 1827                       EXPORT ErrOut2
0139 1827              ErrOut2                                 ; 
0140 1827 2B                    pld   
0141 1828                       EXPORT oErrOut2
0142 1828              oErrOut2                                ; 
0143 1828 A0 02 00              ldy   #2
0144 182B 4C E0 1D              jmp   oErrOut
0145 182E                       ENDP 
0146 182E
0147 182E                       EXPORT oBusyEC2
0148 182E              oBusyEC2 PROC 
0149 182E 0B                    phd   
0150 182F                       EXPORT BusyEC2
0151 182F              BusyEC2                                 ; 
0152 182F A2 00 00              ldx   #0
0153 1832                       EXPORT BusyErr2
0154 1832              BusyErr2                                ; 
0155 1832 2B                    pld   
0156 1833                       EXPORT oBusyErr2
0157 1833              oBusyErr2                               ; 
0158 1833 A0 02 00              ldy   #2
0159 1836 4C 13 1E              jmp   oBusyErr
0160 1839                       ENDP 
0161 1839
0162 1839                       EXPORT oEndCall4
0163 1839              oEndCall4 PROC 
0164 1839 0B                    phd   
0165 183A                       EXPORT EndCall4
0166 183A              EndCall4                                ; 
0167 183A A2 00 00              ldx   #0
0168 183D                       EXPORT ErrOut4
0169 183D              ErrOut4                                 ; 
0170 183D 2B                    pld   
0171 183E                       EXPORT oErrOut4
0172 183E              oErrOut4                                ; 
0173 183E A0 04 00              ldy   #4
0174 1841 4C E0 1D              jmp   oErrOut
0175 1844                       ENDP 
0176 1844
0177 1844                       EXPORT oBusyEC4
0178 1844              oBusyEC4 PROC 
0179 1844 0B                    phd   
0180 1845                       EXPORT BusyEC4
0181 1845              BusyEC4                                 ; 
0182 1845 A2 00 00              ldx   #0
0183 1848                       EXPORT BusyErr4
0184 1848              BusyErr4                                ; 
0185 1848 2B                    pld   
0186 1849                       EXPORT oBusyErr4
0187 1849              oBusyErr4                               ; 
0188 1849 A0 04 00              ldy   #4
0189 184C 4C 13 1E              jmp   oBusyErr
0190 184F                       ENDP 
0191 184F
0192 184F                       EXPORT oEndCall6
0193 184F              oEndCall6 PROC 
0194 184F 0B                    phd   
0195 1850                       EXPORT EndCall6
0196 1850              EndCall6                                ; 
0197 1850 A2 00 00              ldx   #0
0198 1853                       EXPORT ErrOut6
0199 1853              ErrOut6                                 ; 
0200 1853 2B                    pld   
0201 1854                       EXPORT oErrOut6
0202 1854              oErrOut6                                ; 
0203 1854 A0 06 00              ldy   #6
0204 1857 4C E0 1D              jmp   oErrOut
0205 185A                       ENDP 
0206 185A
0207 185A                       EXPORT oBusyEC6
0208 185A              oBusyEC6 PROC 
0209 185A 0B                    phd   
0210 185B                       EXPORT BusyEC6
0211 185B              BusyEC6                                 ; 
0212 185B A2 00 00              ldx   #0
0213 185E                       EXPORT BusyErr6
0214 185E              BusyErr6                                ; 
0215 185E 2B                    pld   
0216 185F                       EXPORT oBusyErr6
0217 185F              oBusyErr6                               ; 
0218 185F A0 06 00              ldy   #6
0219 1862 4C 13 1E              jmp   oBusyErr
0220 1865                       ENDP 
0221 1865
0222 1865                       EXPORT oEndCall8
0223 1865              oEndCall8 PROC 
0224 1865 0B                    phd   
0225 1866                       EXPORT EndCall8
0226 1866              EndCall8                                ; 
0227 1866 A2 00 00              ldx   #0
0228 1869                       EXPORT ErrOut8
0229 1869              ErrOut8                                 ; 
0230 1869 2B                    pld   
0231 186A                       EXPORT oErrOut8
0232 186A              oErrOut8                                ; 
0233 186A A0 08 00              ldy   #8
0234 186D 4C E0 1D              jmp   oErrOut
0235 1870                       ENDP 
0236 1870
0237 1870                       EXPORT oBusyEC8
0238 1870              oBusyEC8 PROC 
0239 1870 0B                    phd   
0240 1871                       EXPORT BusyEC8
0241 1871              BusyEC8                                 ; 
0242 1871 A2 00 00              ldx   #0
0243 1874                       EXPORT BusyErr8
0244 1874              BusyErr8                                ; 
0245 1874 2B                    pld   
0246 1875                       EXPORT oBusyErr8
0247 1875              oBusyErr8                               ; 
0248 1875 A0 08 00              ldy   #8
0249 1878 4C 13 1E              jmp   oBusyErr
0250 187B                       ENDP 
0251 187B
0252 187B                       EXPORT oEndCall10
0253 187B              oEndCall10 PROC 
0254 187B 0B                    phd   
0255 187C                       EXPORT EndCall10
0256 187C              EndCall10                               ; 
0257 187C A2 00 00              ldx   #0
0258 187F                       EXPORT ErrOut10
0259 187F              ErrOut10                                ; 
0260 187F 2B                    pld   
0261 1880                       EXPORT oErrOut10
0262 1880              oErrOut10                               ; 
0263 1880 A0 0A 00              ldy   #10
0264 1883 4C E0 1D              jmp   oErrOut
0265 1886                       ENDP 
0266 1886
0267 1886                       EXPORT oBusyEC10
0268 1886              oBusyEC10 PROC 
0269 1886 0B                    phd   
0270 1887                       EXPORT BusyEC10
0271 1887              BusyEC10                                ; 
0272 1887 A2 00 00              ldx   #0
0273 188A                       EXPORT BusyErr10
0274 188A              BusyErr10                               ; 
0275 188A 2B                    pld   
0276 188B                       EXPORT oBusyErr10
0277 188B              oBusyErr10                              ; 
0278 188B A0 0A 00              ldy   #10
0279 188E 4C 13 1E              jmp   oBusyErr
0280 1891                       ENDP 
0281 1891
0282 1891                       EXPORT oEndCall12
0283 1891              oEndCall12 PROC 
0284 1891 0B                    phd   
0285 1892                       EXPORT EndCall12
0286 1892              EndCall12                               ; 
0287 1892 A2 00 00              ldx   #0
0288 1895                       EXPORT ErrOut12
0289 1895              ErrOut12                                ; 
0290 1895 2B                    pld   
0291 1896                       EXPORT oErrOut12
0292 1896              oErrOut12                               ; 
0293 1896 A0 0C 00              ldy   #12
0294 1899 4C E0 1D              jmp   oErrOut
0295 189C                       ENDP 
0296 189C
0297 189C                       EXPORT oBusyEC12
0298 189C              oBusyEC12 PROC 
0299 189C 0B                    phd   
0300 189D                       EXPORT BusyEC12
0301 189D              BusyEC12                                ; 
0302 189D A2 00 00              ldx   #0
0303 18A0                       EXPORT BusyErr12
0304 18A0              BusyErr12                               ; 
0305 18A0 2B                    pld   
0306 18A1                       EXPORT oBusyErr12
0307 18A1              oBusyErr12                              ; 
0308 18A1 A0 0C 00              ldy   #12
0309 18A4 4C 13 1E              jmp   oBusyErr
0310 18A7                       ENDP 
0311 18A7
0312 18A7                       EXPORT oEndCall14
0313 18A7              oEndCall14 PROC 
0314 18A7 0B                    phd   
0315 18A8                       EXPORT EndCall14
0316 18A8              EndCall14                               ; 
0317 18A8 A2 00 00              ldx   #0
0318 18AB                       EXPORT ErrOut14
0319 18AB              ErrOut14                                ; 
0320 18AB 2B                    pld   
0321 18AC                       EXPORT oErrOut14
0322 18AC              oErrOut14                               ; 
0323 18AC A0 0E 00              ldy   #14
0324 18AF 4C E0 1D              jmp   oErrOut
0325 18B2                       ENDP 
0326 18B2
0327 18B2                       EXPORT oBusyEC14
0328 18B2              oBusyEC14 PROC 
0329 18B2 0B                    phd   
0330 18B3                       EXPORT BusyEC14
0331 18B3              BusyEC14                                ; 
0332 18B3 A2 00 00              ldx   #0
0333 18B6                       EXPORT BusyErr14
0334 18B6              BusyErr14                               ; 
0335 18B6 2B                    pld   
0336 18B7                       EXPORT oBusyErr14
0337 18B7              oBusyErr14                              ; 
0338 18B7 A0 0E 00              ldy   #14
0339 18BA 4C 13 1E              jmp   oBusyErr
0340 18BD                       ENDP 
0341 18BD
0342 18BD                       EXPORT oEndCall16
0343 18BD              oEndCall16 PROC 
0344 18BD 0B                    phd   
0345 18BE                       EXPORT EndCall16
0346 18BE              EndCall16                               ; 
0347 18BE A2 00 00              ldx   #0
0348 18C1                       EXPORT ErrOut16
0349 18C1              ErrOut16                                ; 
0350 18C1 2B                    pld   
0351 18C2                       EXPORT oErrOut16
0352 18C2              oErrOut16                               ; 
0353 18C2 A0 10 00              ldy   #16
0354 18C5 4C E0 1D              jmp   oErrOut
0355 18C8                       ENDP 
0356 18C8
0357 18C8                       EXPORT oBusyEC16
0358 18C8              oBusyEC16 PROC 
0359 18C8 0B                    phd   
0360 18C9                       EXPORT BusyEC16
0361 18C9              BusyEC16                                ; 
0362 18C9 A2 00 00              ldx   #0
0363 18CC                       EXPORT BusyErr16
0364 18CC              BusyErr16                               ; 
0365 18CC 2B                    pld   
0366 18CD                       EXPORT oBusyErr16
0367 18CD              oBusyErr16                              ; 
0368 18CD A0 10 00              ldy   #16
0369 18D0 4C 13 1E              jmp   oBusyErr
0370 18D3                       ENDP 
0371 18D3
0372 18D3
0373 18D3
0374 18D3
0375 18D3
0376 18D3                       EXPORT Strip
0377 18D3              Strip    PROC 
0378 18D3
0379 18D3                       EXPORT BusyEC
0380 18D3              BusyEC                                  ; 
0381 18D3 A2 00 00              ldx   #0
0382 18D6
0383 18D6                       EXPORT BusyErr
0384 18D6              BusyErr                                 ; 
0385 18D6 22 68 00 E1           jsl   DecBusyFlg
0386 18DA 80 03                 bra   ErrOut
0387 18DC
0388 18DC                       EXPORT EndCall
0389 18DC              EndCall                                 ; 
0390 18DC A2 00 00              ldx   #0
0391 18DF
0392 18DF                       EXPORT ErrOut
0393 18DF              ErrOut                                  ; 
0394 18DF 2B                    pld                            ; restore direct register
0395 18E0
0396 18E0
0397 18E0                       EXPORT oErrOut
0398 18E0              oErrOut          
0399 18E0 5A                    phy                            ; save amount to strip on stack
0400 18E1 3B                    tsc                            ; get stack pointer
0401 18E2 18                    clc                            ; add to it the amount to strip
0402 18E3 63 01                 adc   1,s
0403 18E5 A8                    tay                            ; put this result in Y
0404 18E6 3B                    tsc                            ; get back orig stack pointer
0405 18E7 DA                    phx                            ; save error on stack
0406 18E8 AA                    tax                            ; put orig stack in X
0407 18E9 8B                    phb                            ; now save the data bank reg
0408 18EA F4 00 00              pea   $0000                    ; set data bank reg to 0
0409 18ED AB                    plb   
0410 18EE AB                    plb   
0411 18EF BD 07 00              lda   |3+4,x                   ;now use x and y to move 6 bytes
0412 18F2 99 07 00              sta   |3+4,y                   ; of rtl info from current pos
0413 18F5 BD 05 00              lda   |3+2,x                   ; to final pos.
0414 18F8 99 05 00              sta   |3+2,y
0415 18FB BD 03 00              lda   |3+0,x
0416 18FE 99 03 00              sta   |3+0,y
0417 1901 AB                    plb                            ; restore data bank register
0418 1902 FA                    plx                            ; restore x register with error
0419 1903
0420 1903 3B                    tsc                            ; get stack again
0421 1904 18                    clc                            ; bump it by amount to strip Plus 2
0422 1905 63 01                 adc   1,s                      ; to make up for amount to strip
0423 1907 69 02 00              adc   #2                       ; still on stack
0424 190A 1B                    tcs                            ; reset stack pointer
0425 190B 8A                    txa                            ; error into a-reg
0426 190C C9 01 00              cmp   #1                       ; set carry correctly
0427 190F 6B                    rtl                            ; fini
0428 1910
0429 1910
0430 1910
0431 1910
0432 1910                       EXPORT oBusyEC
0433 1910              oBusyEC                                 ; 
0434 1910 A2 00 00              ldx   #0
0435 1913
0436 1913                       EXPORT oBusyErr
0437 1913              oBusyErr                                ; 
0438 1913 22 68 00 E1           jsl   DecBusyFlg
0439 1917 80 C7                 bra   oErrOut
0440 1919
0441 1919                       EXPORT oEndCall
0442 1919              oEndCall                                ; 
0443 1919 A2 00 00              ldx   #0
0444 191C 80 C2                 bra   oErrOut
0445 191E
0446 191E                       ENDP 
0447 191E
0448 191E
0449 191E                       END   
